clear all

* Set Folder to output one

cd ..\Outputs

* Call dataset of revisions and shocks combined (COMB)

use COMB, clear

gen time=year+(qua-1)/4
egen t=group(year quarter)
tsset t

capture drop MPOa
gen MPOa=MPO
replace MPOa=0 if MPO==. & year>2008

gen dlogY=log(GDPC96/l.GDPC96)*400

* Dummy variable for the Great Recession

gen DGR=(time==2008 | time==2008.25 | time==2008.5 | time==2008.75 | time==2009 | time==2009.25)

local confidenceval=0.95

if `confidenceval'==1.65 local confidencestr="90%"
if `confidenceval'==0.95 local confidencestr="66%"

local confidence=66

*===============================================================================
*			       Variables with contemporanous response
*===============================================================================

quiet foreach var in TFP sFP1SPF1 FP2 DE1 DE2 OIL OILK OILBH {
	
	*** define strings for titles of IRF figures
	if "`var'"=="TFP" local var_str="TFP shock (Fernald)"
	if "`var'"=="sFP1SPF1" local var_str="Gov't spending shock (AG 2012)"
	if "`var'"=="DE1" local var_str="Military spending shock (Ramey 2016)"
	if "`var'"=="DE2" local var_str="Military spending shock (Ramey 2016)"
	if "`var'"=="OIL" local var_str="Oil supply shock (Kilian 2004)"
	if "`var'"=="OILK" local var_str="Oil supply shock (Kilian 2009)"
	if "`var'"=="OILBH" local var_str="Oil supply shock (Baumeister and Hamilton 2015)"
	if "`var'"=="FP2" local var_str="Tax shock (Romer and Romer 2010)"
	
	capture drop Z*
	gen Z=`var'
	sum Z
	replace Z=Z/r(sd)
	
	* Create current and lagged values of the shock
	
	forvalues i=0(1)8 {
		gen Z`i'=l`i'.Z
	}
	
	reg GREgRpot0 dlogY Z?
	capture drop smpl0
	gen smpl0=e(sample)
	gen Y=Z
	drop Z
	
	var GREgRpot0 if smpl0==1, lags(1/4) exog(l(0/8).Y D911 DGR)
	irf create irf0, step(8) set(myirf1, replace)
	
	preserve
	use myirf1.irf, clear
	keep if impulse=="Y" & response=="GREgRpot0" & irfname=="irf0" & step==8
	local pointestadl=cdm      
	local standerradl=stdcdm
	restore
	local pval_pot_irf=strofreal((1-normal(abs(`pointestadl'/`standerradl')))*2,"%4.3f")
	
	reg GREgRpot0 l(1/4).GREgRpot0 l(0/8).Y D911 DGR if smpl0==1, robust

	nlcom ///
	(r0: _b[Y]) ///
	(r1: _b[l.Y] ///
	+_b[l.GREgRpot0]*_b[Y]) ///
	(r2: _b[l2.Y] ///
	+_b[l.GREgRpot0]*_b[l.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[Y]) ///
	(r3: _b[l3.Y] ///
	+_b[l.GREgRpot0]*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l1.Y] ///
	+(_b[l.GREgRpot0]^3+2*_b[l.GREgRpot0]*_b[l2.GREgRpot0]+_b[l3.GREgRpot0])*_b[Y]) ///
	(r4: _b[l4.Y] ///
	+_b[l.GREgRpot0]*_b[l3.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^3+2*_b[l.GREgRpot0]*_b[l2.GREgRpot0]+_b[l3.GREgRpot0])*_b[l.Y] ///
	+(_b[l.GREgRpot0]^4+3*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]+2*_b[l.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^2+_b[l4.GREgRpot0])*_b[Y]) ///
	(r5: _b[l5.Y] ///
	+_b[l.GREgRpot0]*_b[l4.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l3.Y] ///
	+(_b[l.GREgRpot0]^3+2*_b[l.GREgRpot0]*_b[l2.GREgRpot0]+_b[l3.GREgRpot0])*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^4+3*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]+2*_b[l.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^2+_b[l4.GREgRpot0])*_b[l.Y] ///
	+(_b[l.GREgRpot0]^5+4*_b[l.GREgRpot0]^3*_b[l2.GREgRpot0]+3*_b[l.GREgRpot0]^2*_b[l3.GREgRpot0]+3*_b[l.GREgRpot0]*_b[l2.GREgRpot0]^2+2*_b[l.GREgRpot0]*_b[l4.GREgRpot0]+2*_b[l2.GREgRpot0]*_b[l3.GREgRpot0])*_b[Y]) ///
	(r6: _b[l6.Y] ///
	+_b[l.GREgRpot0]*_b[l5.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l4.Y] ///
	+(_b[l.GREgRpot0]^3+2*_b[l.GREgRpot0]*_b[l2.GREgRpot0]+_b[l3.GREgRpot0])*_b[l3.Y] ///
	+(_b[l.GREgRpot0]^4+3*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]+2*_b[l.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^2+_b[l4.GREgRpot0])*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^5+4*_b[l.GREgRpot0]^3*_b[l2.GREgRpot0]+3*_b[l.GREgRpot0]^2*_b[l3.GREgRpot0]+3*_b[l.GREgRpot0]*_b[l2.GREgRpot0]^2+2*_b[l.GREgRpot0]*_b[l4.GREgRpot0]+2*_b[l2.GREgRpot0]*_b[l3.GREgRpot0])*_b[l.Y] ///
	+(_b[l.GREgRpot0]^6+5*_b[l.GREgRpot0]^4*_b[l2.GREgRpot0]+4*_b[l.GREgRpot0]^3*_b[l3.GREgRpot0]+6*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]^2+3*_b[l.GREgRpot0]^2*_b[l4.GREgRpot0]+6*_b[l.GREgRpot0]*_b[l2.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^3+2*_b[l2.GREgRpot0]*_b[l4.GREgRpot0]+_b[l3.GREgRpot0]^2)*_b[Y]) ///
	(r7: _b[l7.Y] ///
	+_b[l.GREgRpot0]*_b[l6.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l5.Y] ///
	+(_b[l.GREgRpot0]^3+2*_b[l.GREgRpot0]*_b[l2.GREgRpot0]+_b[l3.GREgRpot0])*_b[l4.Y] ///
	+(_b[l.GREgRpot0]^4+3*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]+2*_b[l.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^2+_b[l4.GREgRpot0])*_b[l3.Y] ///
	+(_b[l.GREgRpot0]^5+4*_b[l.GREgRpot0]^3*_b[l2.GREgRpot0]+3*_b[l.GREgRpot0]^2*_b[l3.GREgRpot0]+3*_b[l.GREgRpot0]*_b[l2.GREgRpot0]^2+2*_b[l.GREgRpot0]*_b[l4.GREgRpot0]+2*_b[l2.GREgRpot0]*_b[l3.GREgRpot0])*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^6+5*_b[l.GREgRpot0]^4*_b[l2.GREgRpot0]+4*_b[l.GREgRpot0]^3*_b[l3.GREgRpot0]+6*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]^2+3*_b[l.GREgRpot0]^2*_b[l4.GREgRpot0]+6*_b[l.GREgRpot0]*_b[l2.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^3+2*_b[l2.GREgRpot0]*_b[l4.GREgRpot0]+_b[l3.GREgRpot0]^2)*_b[l.Y] ///
	+(_b[l.GREgRpot0]^7+6*_b[l.GREgRpot0]^5*_b[l2.GREgRpot0]+5*_b[l.GREgRpot0]^4*_b[l3.GREgRpot0]+10*_b[l.GREgRpot0]^3*_b[l2.GREgRpot0]^2+4*_b[l.GREgRpot0]^3*_b[l4.GREgRpot0]+12*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]*_b[l3.GREgRpot0]+4*_b[l.GREgRpot0]*_b[l2.GREgRpot0]^3+6*_b[l.GREgRpot0]*_b[l2.GREgRpot0]*_b[l4.GREgRpot0]+3*_b[l.GREgRpot0]*_b[l3.GREgRpot0]^2+3*_b[l2.GREgRpot0]^2*_b[l3.GREgRpot0]+2*_b[l3.GREgRpot0]*_b[l4.GREgRpot0])*_b[Y]) ///
	(r8: _b[l8.Y] ///
	+_b[l.GREgRpot0]*_b[l7.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l6.Y] ///
	+(_b[l.GREgRpot0]^3+2*_b[l.GREgRpot0]*_b[l2.GREgRpot0]+_b[l3.GREgRpot0])*_b[l5.Y] ///
	+(_b[l.GREgRpot0]^4+3*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]+2*_b[l.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^2+_b[l4.GREgRpot0])*_b[l4.Y] ///
	+(_b[l.GREgRpot0]^5+4*_b[l.GREgRpot0]^3*_b[l2.GREgRpot0]+3*_b[l.GREgRpot0]^2*_b[l3.GREgRpot0]+3*_b[l.GREgRpot0]*_b[l2.GREgRpot0]^2+2*_b[l.GREgRpot0]*_b[l4.GREgRpot0]+2*_b[l2.GREgRpot0]*_b[l3.GREgRpot0])*_b[l3.Y] ///
	+(_b[l.GREgRpot0]^6+5*_b[l.GREgRpot0]^4*_b[l2.GREgRpot0]+4*_b[l.GREgRpot0]^3*_b[l3.GREgRpot0]+6*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]^2+3*_b[l.GREgRpot0]^2*_b[l4.GREgRpot0]+6*_b[l.GREgRpot0]*_b[l2.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^3+2*_b[l2.GREgRpot0]*_b[l4.GREgRpot0]+_b[l3.GREgRpot0]^2)*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^7+6*_b[l.GREgRpot0]^5*_b[l2.GREgRpot0]+5*_b[l.GREgRpot0]^4*_b[l3.GREgRpot0]+10*_b[l.GREgRpot0]^3*_b[l2.GREgRpot0]^2+4*_b[l.GREgRpot0]^3*_b[l4.GREgRpot0]+12*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]*_b[l3.GREgRpot0]+4*_b[l.GREgRpot0]*_b[l2.GREgRpot0]^3+6*_b[l.GREgRpot0]*_b[l2.GREgRpot0]*_b[l4.GREgRpot0]+3*_b[l.GREgRpot0]*_b[l3.GREgRpot0]^2+3*_b[l2.GREgRpot0]^2*_b[l3.GREgRpot0]+2*_b[l3.GREgRpot0]*_b[l4.GREgRpot0])*_b[l.Y] ///
	+(_b[l.GREgRpot0]^8+7*_b[l.GREgRpot0]^6*_b[l2.GREgRpot0]+6*_b[l.GREgRpot0]^5*_b[l3.GREgRpot0]+15*_b[l.GREgRpot0]^4*_b[l2.GREgRpot0]^2+5*_b[l.GREgRpot0]^4*_b[l4.GREgRpot0]+20*_b[l.GREgRpot0]^3*_b[l2.GREgRpot0]*_b[l3.GREgRpot0]+10*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]^3+12*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]*_b[l4.GREgRpot0]+6*_b[l.GREgRpot0]^2*_b[l3.GREgRpot0]^2+12*_b[l.GREgRpot0]*_b[l2.GREgRpot0]^2*_b[l3.GREgRpot0]+6*_b[l.GREgRpot0]*_b[l3.GREgRpot0]*_b[l4.GREgRpot0]+_b[l2.GREgRpot0]^4+3*_b[l2.GREgRpot0]^2*_b[l4.GREgRpot0]+3*_b[l2.GREgRpot0]*_b[l3.GREgRpot0]^2+_b[l4.GREgRpot0]^2)*_b[Y]) ///
	, post

	test (r0=0) (r0+r1=0) (r0+r1+r2=0) (r0+r1+r2+r3=0) (r0+r1+r2+r3+r4=0) (r0+r1+r2+r3+r4+r5=0) (r0+r1+r2+r3+r4+r5+r6=0) (r0+r1+r2+r3+r4+r5+r6+r7=0) (r0+r1+r2+r3+r4+r5+r6+r7+r8=0)
	local pval_pot_irf_point=strofreal(r(p),"%4.3f")
	
	test (r0+r1+r2+r3+r4+r5+r6+r7+r8=0)
	local pval_pot_irf2=strofreal(r(p),"%4.3f") 
	
	var dlogY if smpl0==1, lags(1/4) exog(l(0/8).Y D911 DGR)
	irf create irf1, step(8)
	
	preserve
	use myirf1.irf, clear
	keep if impulse=="Y" & response=="dlogY" & irfname=="irf1" & step==8
	local pointestadl=cdm      
	local standerradl=stdcdm
	restore
	local pval_act_irf=strofreal((1-normal(abs(`pointestadl'/`standerradl')))*2,"%4.3f")
	
	reg dlogY l(1/4).dlogY l(0/8).Y D911 DGR if smpl0==1, robust

	nlcom ///
	(p0: _b[Y]) ///
	(p1: _b[l.Y] ///
	+_b[l.dlogY]*_b[Y]) ///
	(p2: _b[l2.Y] ///
	+_b[l.dlogY]*_b[l.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[Y]) ///
	(p3: _b[l3.Y] ///
	+_b[l.dlogY]*_b[l2.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l1.Y] ///
	+(_b[l.dlogY]^3+2*_b[l.dlogY]*_b[l2.dlogY]+_b[l3.dlogY])*_b[Y]) ///
	(p4: _b[l4.Y] ///
	+_b[l.dlogY]*_b[l3.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l2.Y] ///
	+(_b[l.dlogY]^3+2*_b[l.dlogY]*_b[l2.dlogY]+_b[l3.dlogY])*_b[l.Y] ///
	+(_b[l.dlogY]^4+3*_b[l.dlogY]^2*_b[l2.dlogY]+2*_b[l.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^2+_b[l4.dlogY])*_b[Y]) ///
	(p5: _b[l5.Y] ///
	+_b[l.dlogY]*_b[l4.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l3.Y] ///
	+(_b[l.dlogY]^3+2*_b[l.dlogY]*_b[l2.dlogY]+_b[l3.dlogY])*_b[l2.Y] ///
	+(_b[l.dlogY]^4+3*_b[l.dlogY]^2*_b[l2.dlogY]+2*_b[l.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^2+_b[l4.dlogY])*_b[l.Y] ///
	+(_b[l.dlogY]^5+4*_b[l.dlogY]^3*_b[l2.dlogY]+3*_b[l.dlogY]^2*_b[l3.dlogY]+3*_b[l.dlogY]*_b[l2.dlogY]^2+2*_b[l.dlogY]*_b[l4.dlogY]+2*_b[l2.dlogY]*_b[l3.dlogY])*_b[Y]) ///
	(p6: _b[l6.Y] ///
	+_b[l.dlogY]*_b[l5.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l4.Y] ///
	+(_b[l.dlogY]^3+2*_b[l.dlogY]*_b[l2.dlogY]+_b[l3.dlogY])*_b[l3.Y] ///
	+(_b[l.dlogY]^4+3*_b[l.dlogY]^2*_b[l2.dlogY]+2*_b[l.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^2+_b[l4.dlogY])*_b[l2.Y] ///
	+(_b[l.dlogY]^5+4*_b[l.dlogY]^3*_b[l2.dlogY]+3*_b[l.dlogY]^2*_b[l3.dlogY]+3*_b[l.dlogY]*_b[l2.dlogY]^2+2*_b[l.dlogY]*_b[l4.dlogY]+2*_b[l2.dlogY]*_b[l3.dlogY])*_b[l.Y] ///
	+(_b[l.dlogY]^6+5*_b[l.dlogY]^4*_b[l2.dlogY]+4*_b[l.dlogY]^3*_b[l3.dlogY]+6*_b[l.dlogY]^2*_b[l2.dlogY]^2+3*_b[l.dlogY]^2*_b[l4.dlogY]+6*_b[l.dlogY]*_b[l2.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^3+2*_b[l2.dlogY]*_b[l4.dlogY]+_b[l3.dlogY]^2)*_b[Y]) ///
	(p7: _b[l7.Y] ///
	+_b[l.dlogY]*_b[l6.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l5.Y] ///
	+(_b[l.dlogY]^3+2*_b[l.dlogY]*_b[l2.dlogY]+_b[l3.dlogY])*_b[l4.Y] ///
	+(_b[l.dlogY]^4+3*_b[l.dlogY]^2*_b[l2.dlogY]+2*_b[l.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^2+_b[l4.dlogY])*_b[l3.Y] ///
	+(_b[l.dlogY]^5+4*_b[l.dlogY]^3*_b[l2.dlogY]+3*_b[l.dlogY]^2*_b[l3.dlogY]+3*_b[l.dlogY]*_b[l2.dlogY]^2+2*_b[l.dlogY]*_b[l4.dlogY]+2*_b[l2.dlogY]*_b[l3.dlogY])*_b[l2.Y] ///
	+(_b[l.dlogY]^6+5*_b[l.dlogY]^4*_b[l2.dlogY]+4*_b[l.dlogY]^3*_b[l3.dlogY]+6*_b[l.dlogY]^2*_b[l2.dlogY]^2+3*_b[l.dlogY]^2*_b[l4.dlogY]+6*_b[l.dlogY]*_b[l2.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^3+2*_b[l2.dlogY]*_b[l4.dlogY]+_b[l3.dlogY]^2)*_b[l.Y] ///
	+(_b[l.dlogY]^7+6*_b[l.dlogY]^5*_b[l2.dlogY]+5*_b[l.dlogY]^4*_b[l3.dlogY]+10*_b[l.dlogY]^3*_b[l2.dlogY]^2+4*_b[l.dlogY]^3*_b[l4.dlogY]+12*_b[l.dlogY]^2*_b[l2.dlogY]*_b[l3.dlogY]+4*_b[l.dlogY]*_b[l2.dlogY]^3+6*_b[l.dlogY]*_b[l2.dlogY]*_b[l4.dlogY]+3*_b[l.dlogY]*_b[l3.dlogY]^2+3*_b[l2.dlogY]^2*_b[l3.dlogY]+2*_b[l3.dlogY]*_b[l4.dlogY])*_b[Y]) ///
	(p8: _b[l8.Y] ///
	+_b[l.dlogY]*_b[l7.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l6.Y] ///
	+(_b[l.dlogY]^3+2*_b[l.dlogY]*_b[l2.dlogY]+_b[l3.dlogY])*_b[l5.Y] ///
	+(_b[l.dlogY]^4+3*_b[l.dlogY]^2*_b[l2.dlogY]+2*_b[l.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^2+_b[l4.dlogY])*_b[l4.Y] ///
	+(_b[l.dlogY]^5+4*_b[l.dlogY]^3*_b[l2.dlogY]+3*_b[l.dlogY]^2*_b[l3.dlogY]+3*_b[l.dlogY]*_b[l2.dlogY]^2+2*_b[l.dlogY]*_b[l4.dlogY]+2*_b[l2.dlogY]*_b[l3.dlogY])*_b[l3.Y] ///
	+(_b[l.dlogY]^6+5*_b[l.dlogY]^4*_b[l2.dlogY]+4*_b[l.dlogY]^3*_b[l3.dlogY]+6*_b[l.dlogY]^2*_b[l2.dlogY]^2+3*_b[l.dlogY]^2*_b[l4.dlogY]+6*_b[l.dlogY]*_b[l2.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^3+2*_b[l2.dlogY]*_b[l4.dlogY]+_b[l3.dlogY]^2)*_b[l2.Y] ///
	+(_b[l.dlogY]^7+6*_b[l.dlogY]^5*_b[l2.dlogY]+5*_b[l.dlogY]^4*_b[l3.dlogY]+10*_b[l.dlogY]^3*_b[l2.dlogY]^2+4*_b[l.dlogY]^3*_b[l4.dlogY]+12*_b[l.dlogY]^2*_b[l2.dlogY]*_b[l3.dlogY]+4*_b[l.dlogY]*_b[l2.dlogY]^3+6*_b[l.dlogY]*_b[l2.dlogY]*_b[l4.dlogY]+3*_b[l.dlogY]*_b[l3.dlogY]^2+3*_b[l2.dlogY]^2*_b[l3.dlogY]+2*_b[l3.dlogY]*_b[l4.dlogY])*_b[l.Y] ///
	+(_b[l.dlogY]^8+7*_b[l.dlogY]^6*_b[l2.dlogY]+6*_b[l.dlogY]^5*_b[l3.dlogY]+15*_b[l.dlogY]^4*_b[l2.dlogY]^2+5*_b[l.dlogY]^4*_b[l4.dlogY]+20*_b[l.dlogY]^3*_b[l2.dlogY]*_b[l3.dlogY]+10*_b[l.dlogY]^2*_b[l2.dlogY]^3+12*_b[l.dlogY]^2*_b[l2.dlogY]*_b[l4.dlogY]+6*_b[l.dlogY]^2*_b[l3.dlogY]^2+12*_b[l.dlogY]*_b[l2.dlogY]^2*_b[l3.dlogY]+6*_b[l.dlogY]*_b[l3.dlogY]*_b[l4.dlogY]+_b[l2.dlogY]^4+3*_b[l2.dlogY]^2*_b[l4.dlogY]+3*_b[l2.dlogY]*_b[l3.dlogY]^2+_b[l4.dlogY]^2)*_b[Y]) ///
	, post

	test (p0=0) (p0+p1=0) (p0+p1+p2=0) (p0+p1+p2+p3=0) (p0+p1+p2+p3+p4=0) (p0+p1+p2+p3+p4+p5=0) (p0+p1+p2+p3+p4+p5+p6=0) (p0+p1+p2+p3+p4+p5+p6+p7=0) (p0+p1+p2+p3+p4+p5+p6+p7+p8=0)
	local pval_act_irf_point=strofreal(r(p),"%4.3f")
	
	test (p0+p1+p2+p3+p4+p5+p6+p7+p8=0)
	local pval_act_irf2=strofreal(r(p),"%4.3f")
	
	sureg (E1: GREgRpot0 l(1/4).GREgRpot0 l(0/8).Y D911 DGR if smpl0==1) (E2: dlogY l(1/4).dlogY l(0/8).Y D911 DGR if smpl0==1), small dfk

	nlcom ///
	(r0: _b[E1:Y]) ///
	(r1: _b[E1:l.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:Y]) ///
	(r2: _b[E1:l2.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:Y]) ///
	(r3: _b[E1:l3.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l1.Y] ///
	+(_b[E1:l.GREgRpot0]^3+2*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]+_b[E1:l3.GREgRpot0])*_b[E1:Y]) ///
	(r4: _b[E1:l4.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l3.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^3+2*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]+_b[E1:l3.GREgRpot0])*_b[E1:l.Y] ///
	+(_b[E1:l.GREgRpot0]^4+3*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]+2*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^2+_b[E1:l4.GREgRpot0])*_b[E1:Y]) ///
	(r5: _b[E1:l5.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l4.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l3.Y] ///
	+(_b[E1:l.GREgRpot0]^3+2*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]+_b[E1:l3.GREgRpot0])*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^4+3*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]+2*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^2+_b[E1:l4.GREgRpot0])*_b[E1:l.Y] ///
	+(_b[E1:l.GREgRpot0]^5+4*_b[E1:l.GREgRpot0]^3*_b[E1:l2.GREgRpot0]+3*_b[E1:l.GREgRpot0]^2*_b[E1:l3.GREgRpot0]+3*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]^2+2*_b[E1:l.GREgRpot0]*_b[E1:l4.GREgRpot0]+2*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0])*_b[E1:Y]) ///
	(r6: _b[E1:l6.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l5.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l4.Y] ///
	+(_b[E1:l.GREgRpot0]^3+2*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]+_b[E1:l3.GREgRpot0])*_b[E1:l3.Y] ///
	+(_b[E1:l.GREgRpot0]^4+3*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]+2*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^2+_b[E1:l4.GREgRpot0])*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^5+4*_b[E1:l.GREgRpot0]^3*_b[E1:l2.GREgRpot0]+3*_b[E1:l.GREgRpot0]^2*_b[E1:l3.GREgRpot0]+3*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]^2+2*_b[E1:l.GREgRpot0]*_b[E1:l4.GREgRpot0]+2*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0])*_b[E1:l.Y] ///
	+(_b[E1:l.GREgRpot0]^6+5*_b[E1:l.GREgRpot0]^4*_b[E1:l2.GREgRpot0]+4*_b[E1:l.GREgRpot0]^3*_b[E1:l3.GREgRpot0]+6*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]^2+3*_b[E1:l.GREgRpot0]^2*_b[E1:l4.GREgRpot0]+6*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^3+2*_b[E1:l2.GREgRpot0]*_b[E1:l4.GREgRpot0]+_b[E1:l3.GREgRpot0]^2)*_b[E1:Y]) ///
	(r7: _b[E1:l7.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l6.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l5.Y] ///
	+(_b[E1:l.GREgRpot0]^3+2*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]+_b[E1:l3.GREgRpot0])*_b[E1:l4.Y] ///
	+(_b[E1:l.GREgRpot0]^4+3*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]+2*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^2+_b[E1:l4.GREgRpot0])*_b[E1:l3.Y] ///
	+(_b[E1:l.GREgRpot0]^5+4*_b[E1:l.GREgRpot0]^3*_b[E1:l2.GREgRpot0]+3*_b[E1:l.GREgRpot0]^2*_b[E1:l3.GREgRpot0]+3*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]^2+2*_b[E1:l.GREgRpot0]*_b[E1:l4.GREgRpot0]+2*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0])*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^6+5*_b[E1:l.GREgRpot0]^4*_b[E1:l2.GREgRpot0]+4*_b[E1:l.GREgRpot0]^3*_b[E1:l3.GREgRpot0]+6*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]^2+3*_b[E1:l.GREgRpot0]^2*_b[E1:l4.GREgRpot0]+6*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^3+2*_b[E1:l2.GREgRpot0]*_b[E1:l4.GREgRpot0]+_b[E1:l3.GREgRpot0]^2)*_b[E1:l.Y] ///
	+(_b[E1:l.GREgRpot0]^7+6*_b[E1:l.GREgRpot0]^5*_b[E1:l2.GREgRpot0]+5*_b[E1:l.GREgRpot0]^4*_b[E1:l3.GREgRpot0]+10*_b[E1:l.GREgRpot0]^3*_b[E1:l2.GREgRpot0]^2+4*_b[E1:l.GREgRpot0]^3*_b[E1:l4.GREgRpot0]+12*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0]+4*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]^3+6*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]*_b[E1:l4.GREgRpot0]+3*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]^2+3*_b[E1:l2.GREgRpot0]^2*_b[E1:l3.GREgRpot0]+2*_b[E1:l3.GREgRpot0]*_b[E1:l4.GREgRpot0])*_b[E1:Y]) ///
	(r8: _b[E1:l8.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l7.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l6.Y] ///
	+(_b[E1:l.GREgRpot0]^3+2*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]+_b[E1:l3.GREgRpot0])*_b[E1:l5.Y] ///
	+(_b[E1:l.GREgRpot0]^4+3*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]+2*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^2+_b[E1:l4.GREgRpot0])*_b[E1:l4.Y] ///
	+(_b[E1:l.GREgRpot0]^5+4*_b[E1:l.GREgRpot0]^3*_b[E1:l2.GREgRpot0]+3*_b[E1:l.GREgRpot0]^2*_b[E1:l3.GREgRpot0]+3*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]^2+2*_b[E1:l.GREgRpot0]*_b[E1:l4.GREgRpot0]+2*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0])*_b[E1:l3.Y] ///
	+(_b[E1:l.GREgRpot0]^6+5*_b[E1:l.GREgRpot0]^4*_b[E1:l2.GREgRpot0]+4*_b[E1:l.GREgRpot0]^3*_b[E1:l3.GREgRpot0]+6*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]^2+3*_b[E1:l.GREgRpot0]^2*_b[E1:l4.GREgRpot0]+6*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^3+2*_b[E1:l2.GREgRpot0]*_b[E1:l4.GREgRpot0]+_b[E1:l3.GREgRpot0]^2)*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^7+6*_b[E1:l.GREgRpot0]^5*_b[E1:l2.GREgRpot0]+5*_b[E1:l.GREgRpot0]^4*_b[E1:l3.GREgRpot0]+10*_b[E1:l.GREgRpot0]^3*_b[E1:l2.GREgRpot0]^2+4*_b[E1:l.GREgRpot0]^3*_b[E1:l4.GREgRpot0]+12*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0]+4*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]^3+6*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]*_b[E1:l4.GREgRpot0]+3*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]^2+3*_b[E1:l2.GREgRpot0]^2*_b[E1:l3.GREgRpot0]+2*_b[E1:l3.GREgRpot0]*_b[E1:l4.GREgRpot0])*_b[E1:l.Y] ///
	+(_b[E1:l.GREgRpot0]^8+7*_b[E1:l.GREgRpot0]^6*_b[E1:l2.GREgRpot0]+6*_b[E1:l.GREgRpot0]^5*_b[E1:l3.GREgRpot0]+15*_b[E1:l.GREgRpot0]^4*_b[E1:l2.GREgRpot0]^2+5*_b[E1:l.GREgRpot0]^4*_b[E1:l4.GREgRpot0]+20*_b[E1:l.GREgRpot0]^3*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0]+10*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]^3+12*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]*_b[E1:l4.GREgRpot0]+6*_b[E1:l.GREgRpot0]^2*_b[E1:l3.GREgRpot0]^2+12*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]^2*_b[E1:l3.GREgRpot0]+6*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]*_b[E1:l4.GREgRpot0]+_b[E1:l2.GREgRpot0]^4+3*_b[E1:l2.GREgRpot0]^2*_b[E1:l4.GREgRpot0]+3*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0]^2+_b[E1:l4.GREgRpot0]^2)*_b[E1:Y]) ///
	(p0: _b[E2:Y]) ///
	(p1: _b[E2:l.Y] ///
	+_b[E2:l.dlogY]*_b[E2:Y]) ///
	(p2: _b[E2:l2.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:Y]) ///
	(p3: _b[E2:l3.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l1.Y] ///
	+(_b[E2:l.dlogY]^3+2*_b[E2:l.dlogY]*_b[E2:l2.dlogY]+_b[E2:l3.dlogY])*_b[E2:Y]) ///
	(p4: _b[E2:l4.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l3.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^3+2*_b[E2:l.dlogY]*_b[E2:l2.dlogY]+_b[E2:l3.dlogY])*_b[E2:l.Y] ///
	+(_b[E2:l.dlogY]^4+3*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]+2*_b[E2:l.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^2+_b[E2:l4.dlogY])*_b[E2:Y]) ///
	(p5: _b[E2:l5.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l4.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l3.Y] ///
	+(_b[E2:l.dlogY]^3+2*_b[E2:l.dlogY]*_b[E2:l2.dlogY]+_b[E2:l3.dlogY])*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^4+3*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]+2*_b[E2:l.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^2+_b[E2:l4.dlogY])*_b[E2:l.Y] ///
	+(_b[E2:l.dlogY]^5+4*_b[E2:l.dlogY]^3*_b[E2:l2.dlogY]+3*_b[E2:l.dlogY]^2*_b[E2:l3.dlogY]+3*_b[E2:l.dlogY]*_b[E2:l2.dlogY]^2+2*_b[E2:l.dlogY]*_b[E2:l4.dlogY]+2*_b[E2:l2.dlogY]*_b[E2:l3.dlogY])*_b[E2:Y]) ///
	(p6: _b[E2:l6.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l5.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l4.Y] ///
	+(_b[E2:l.dlogY]^3+2*_b[E2:l.dlogY]*_b[E2:l2.dlogY]+_b[E2:l3.dlogY])*_b[E2:l3.Y] ///
	+(_b[E2:l.dlogY]^4+3*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]+2*_b[E2:l.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^2+_b[E2:l4.dlogY])*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^5+4*_b[E2:l.dlogY]^3*_b[E2:l2.dlogY]+3*_b[E2:l.dlogY]^2*_b[E2:l3.dlogY]+3*_b[E2:l.dlogY]*_b[E2:l2.dlogY]^2+2*_b[E2:l.dlogY]*_b[E2:l4.dlogY]+2*_b[E2:l2.dlogY]*_b[E2:l3.dlogY])*_b[E2:l.Y] ///
	+(_b[E2:l.dlogY]^6+5*_b[E2:l.dlogY]^4*_b[E2:l2.dlogY]+4*_b[E2:l.dlogY]^3*_b[E2:l3.dlogY]+6*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]^2+3*_b[E2:l.dlogY]^2*_b[E2:l4.dlogY]+6*_b[E2:l.dlogY]*_b[E2:l2.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^3+2*_b[E2:l2.dlogY]*_b[E2:l4.dlogY]+_b[E2:l3.dlogY]^2)*_b[E2:Y]) ///
	(p7: _b[E2:l7.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l6.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l5.Y] ///
	+(_b[E2:l.dlogY]^3+2*_b[E2:l.dlogY]*_b[E2:l2.dlogY]+_b[E2:l3.dlogY])*_b[E2:l4.Y] ///
	+(_b[E2:l.dlogY]^4+3*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]+2*_b[E2:l.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^2+_b[E2:l4.dlogY])*_b[E2:l3.Y] ///
	+(_b[E2:l.dlogY]^5+4*_b[E2:l.dlogY]^3*_b[E2:l2.dlogY]+3*_b[E2:l.dlogY]^2*_b[E2:l3.dlogY]+3*_b[E2:l.dlogY]*_b[E2:l2.dlogY]^2+2*_b[E2:l.dlogY]*_b[E2:l4.dlogY]+2*_b[E2:l2.dlogY]*_b[E2:l3.dlogY])*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^6+5*_b[E2:l.dlogY]^4*_b[E2:l2.dlogY]+4*_b[E2:l.dlogY]^3*_b[E2:l3.dlogY]+6*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]^2+3*_b[E2:l.dlogY]^2*_b[E2:l4.dlogY]+6*_b[E2:l.dlogY]*_b[E2:l2.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^3+2*_b[E2:l2.dlogY]*_b[E2:l4.dlogY]+_b[E2:l3.dlogY]^2)*_b[E2:l.Y] ///
	+(_b[E2:l.dlogY]^7+6*_b[E2:l.dlogY]^5*_b[E2:l2.dlogY]+5*_b[E2:l.dlogY]^4*_b[E2:l3.dlogY]+10*_b[E2:l.dlogY]^3*_b[E2:l2.dlogY]^2+4*_b[E2:l.dlogY]^3*_b[E2:l4.dlogY]+12*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]*_b[E2:l3.dlogY]+4*_b[E2:l.dlogY]*_b[E2:l2.dlogY]^3+6*_b[E2:l.dlogY]*_b[E2:l2.dlogY]*_b[E2:l4.dlogY]+3*_b[E2:l.dlogY]*_b[E2:l3.dlogY]^2+3*_b[E2:l2.dlogY]^2*_b[E2:l3.dlogY]+2*_b[E2:l3.dlogY]*_b[E2:l4.dlogY])*_b[E2:Y]) ///
	(p8: _b[E2:l8.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l7.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l6.Y] ///
	+(_b[E2:l.dlogY]^3+2*_b[E2:l.dlogY]*_b[E2:l2.dlogY]+_b[E2:l3.dlogY])*_b[E2:l5.Y] ///
	+(_b[E2:l.dlogY]^4+3*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]+2*_b[E2:l.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^2+_b[E2:l4.dlogY])*_b[E2:l4.Y] ///
	+(_b[E2:l.dlogY]^5+4*_b[E2:l.dlogY]^3*_b[E2:l2.dlogY]+3*_b[E2:l.dlogY]^2*_b[E2:l3.dlogY]+3*_b[E2:l.dlogY]*_b[E2:l2.dlogY]^2+2*_b[E2:l.dlogY]*_b[E2:l4.dlogY]+2*_b[E2:l2.dlogY]*_b[E2:l3.dlogY])*_b[E2:l3.Y] ///
	+(_b[E2:l.dlogY]^6+5*_b[E2:l.dlogY]^4*_b[E2:l2.dlogY]+4*_b[E2:l.dlogY]^3*_b[E2:l3.dlogY]+6*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]^2+3*_b[E2:l.dlogY]^2*_b[E2:l4.dlogY]+6*_b[E2:l.dlogY]*_b[E2:l2.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^3+2*_b[E2:l2.dlogY]*_b[E2:l4.dlogY]+_b[E2:l3.dlogY]^2)*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^7+6*_b[E2:l.dlogY]^5*_b[E2:l2.dlogY]+5*_b[E2:l.dlogY]^4*_b[E2:l3.dlogY]+10*_b[E2:l.dlogY]^3*_b[E2:l2.dlogY]^2+4*_b[E2:l.dlogY]^3*_b[E2:l4.dlogY]+12*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]*_b[E2:l3.dlogY]+4*_b[E2:l.dlogY]*_b[E2:l2.dlogY]^3+6*_b[E2:l.dlogY]*_b[E2:l2.dlogY]*_b[E2:l4.dlogY]+3*_b[E2:l.dlogY]*_b[E2:l3.dlogY]^2+3*_b[E2:l2.dlogY]^2*_b[E2:l3.dlogY]+2*_b[E2:l3.dlogY]*_b[E2:l4.dlogY])*_b[E2:l.Y] ///
	+(_b[E2:l.dlogY]^8+7*_b[E2:l.dlogY]^6*_b[E2:l2.dlogY]+6*_b[E2:l.dlogY]^5*_b[E2:l3.dlogY]+15*_b[E2:l.dlogY]^4*_b[E2:l2.dlogY]^2+5*_b[E2:l.dlogY]^4*_b[E2:l4.dlogY]+20*_b[E2:l.dlogY]^3*_b[E2:l2.dlogY]*_b[E2:l3.dlogY]+10*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]^3+12*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]*_b[E2:l4.dlogY]+6*_b[E2:l.dlogY]^2*_b[E2:l3.dlogY]^2+12*_b[E2:l.dlogY]*_b[E2:l2.dlogY]^2*_b[E2:l3.dlogY]+6*_b[E2:l.dlogY]*_b[E2:l3.dlogY]*_b[E2:l4.dlogY]+_b[E2:l2.dlogY]^4+3*_b[E2:l2.dlogY]^2*_b[E2:l4.dlogY]+3*_b[E2:l2.dlogY]*_b[E2:l3.dlogY]^2+_b[E2:l4.dlogY]^2)*_b[E2:Y]) ///
	, post
	
	test (r0=0) (r0+r1=0) (r0+r1+r2=0) (r0+r1+r2+r3=0) (r0+r1+r2+r3+r4=0) (r0+r1+r2+r3+r4+r5=0) (r0+r1+r2+r3+r4+r5+r6=0) (r0+r1+r2+r3+r4+r5+r6+r7=0) (r0+r1+r2+r3+r4+r5+r6+r7+r8=0)
	local pval_pot_irf_point2=strofreal(r(p),"%4.3f")
	test (r0+r1+r2+r3+r4+r5+r6+r7+r8=0)
	local pval_pot_irf3=strofreal(r(p),"%4.3f")
	test (p0=0) (p0+p1=0) (p0+p1+p2=0) (p0+p1+p2+p3=0) (p0+p1+p2+p3+p4=0) (p0+p1+p2+p3+p4+p5=0) (p0+p1+p2+p3+p4+p5+p6=0) (p0+p1+p2+p3+p4+p5+p6+p7=0) (p0+p1+p2+p3+p4+p5+p6+p7+p8=0)
	local pval_act_irf_point2=strofreal(r(p),"%4.3f")
	test (p0+p1+p2+p3+p4+p5+p6+p7+p8=0)
	local pval_act_irf3=strofreal(r(p),"%4.3f")
	test (r0=p0) (r0+r1=p0+p1) (r0+r1+r2=p0+p1+p2) (r0+r1+r2+r3=p0+p1+p2+p3) (r0+r1+r2+r3+r4=p0+p1+p2+p3+p4) (r0+r1+r2+r3+r4+r5=p0+p1+p2+p3+p4+p5) (r0+r1+r2+r3+r4+r5+r6=p0+p1+p2+p3+p4+p5+p6) (r0+r1+r2+r3+r4+r5+r6+r7=p0+p1+p2+p3+p4+p5+p6+p7) (r0+r1+r2+r3+r4+r5+r6+r7+r8=p0+p1+p2+p3+p4+p5+p6+p7+p8)
	local pval_dif_irf_point=strofreal(r(p),"%4.3f")
	test (r0+r1+r2+r3+r4+r5+r6+r7+r8=p0+p1+p2+p3+p4+p5+p6+p7+p8)
	local pval_dif_irf=strofreal(r(p),"%4.3f")
	
	n disp "Potential"
	
	n display `pval_pot_irf_point'
	n display `pval_pot_irf_point2'
	n display `pval_pot_irf'
	n display `pval_pot_irf2'
	n display `pval_pot_irf3'
	
	n disp "Actual"
	
	n display `pval_act_irf_point'
	n display `pval_act_irf_point2'
	n display `pval_act_irf'
	n display `pval_act_irf2'
	n display `pval_act_irf3'
	
	n disp "Difference"
	
	n display `pval_dif_irf_point'
	n display `pval_dif_irf'

	irf ograph ///
	(irf1 Y dlogY cdm, ci level(`confidence') lcolor(black) ciopts(lcolor(gs14) fcolor(gs14)) lwidth(thick)) ///
	(irf0 Y GREgRpot0 cdm, ci level(`confidence') lcolor(blue) ciopts(lcolor(blue) lpattern(dash) fcolor(none))) ///
	, legend(order(3 1 4 2 6) ///
	label(3 "Actual Output, (`pval_act_irf2') [`pval_act_irf_point']") ///
	label(1 "`confidencestr' CI") ///
	label(2 "`confidencestr' CI") ///
	label(4 "Poten. Output, (`pval_pot_irf2') [`pval_pot_irf_point']") ///
	label(6 "Actual=Poten., (`pval_dif_irf') [`pval_dif_irf_point']") ///
	rows(3) ring(3) position(7)) ///
	xlabel(0(1)8) xtitle("") ///
	ytitle("output growth rate, percent, annualized") ///
	title("`var_str'") ///
	graphregion(color(white)) bgcolor(white) ///
	name(`var', replace)
		
	capture drop Y
	
}

*===============================================================================
*			     Variables with NO contemporanous response
*===============================================================================

quiet foreach var in MPOa MPVAR0 {

	if "`var'"=="MPOa" local var_str="Monetary policy shock (Romer and Romer 2004)"
	if "`var'"=="MPVAR0" local var_str="Monetary policy shock (VAR)"
	
	capture drop Z*
	gen Z=`var'
	sum Z
	replace Z=Z/r(sd)
	
	* Create current and lagged values of the shock
	
	forvalues i=1(1)8 {
		gen Z`i'=l`i'.Z
	}
	
	reg GREgRpot0 dlogY Z?
	capture drop smpl0
	gen smpl0=e(sample)
	
	gen Y=Z
	drop Z
	
	var GREgRpot0 if smpl0==1, lags(1/4) exog(l(1/8).Y D911 DGR)
	irf create irf0, step(8) set(myirf1, replace)
	
	preserve
	use myirf1.irf, clear
	keep if impulse=="Y" & response=="GREgRpot0" & irfname=="irf0" & step==8
	local pointestadl=cdm      
	local standerradl=stdcdm
	restore
	local pval_pot_irf=strofreal((1-normal(abs(`pointestadl'/`standerradl')))*2,"%4.3f")
	
	reg GREgRpot0 l(1/4).GREgRpot0 l(0/8).Y D911 DGR if smpl0==1, robust

	nlcom ///
	(r1: _b[l.Y]) ///
	(r2: _b[l2.Y] ///
	+_b[l.GREgRpot0]*_b[l.Y]) ///
	(r3: _b[l3.Y] ///
	+_b[l.GREgRpot0]*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l1.Y]) ///
	(r4: _b[l4.Y] ///
	+_b[l.GREgRpot0]*_b[l3.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^3+2*_b[l.GREgRpot0]*_b[l2.GREgRpot0]+_b[l3.GREgRpot0])*_b[l.Y]) ///
	(r5: _b[l5.Y] ///
	+_b[l.GREgRpot0]*_b[l4.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l3.Y] ///
	+(_b[l.GREgRpot0]^3+2*_b[l.GREgRpot0]*_b[l2.GREgRpot0]+_b[l3.GREgRpot0])*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^4+3*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]+2*_b[l.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^2+_b[l4.GREgRpot0])*_b[l.Y]) ///
	(r6: _b[l6.Y] ///
	+_b[l.GREgRpot0]*_b[l5.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l4.Y] ///
	+(_b[l.GREgRpot0]^3+2*_b[l.GREgRpot0]*_b[l2.GREgRpot0]+_b[l3.GREgRpot0])*_b[l3.Y] ///
	+(_b[l.GREgRpot0]^4+3*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]+2*_b[l.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^2+_b[l4.GREgRpot0])*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^5+4*_b[l.GREgRpot0]^3*_b[l2.GREgRpot0]+3*_b[l.GREgRpot0]^2*_b[l3.GREgRpot0]+3*_b[l.GREgRpot0]*_b[l2.GREgRpot0]^2+2*_b[l.GREgRpot0]*_b[l4.GREgRpot0]+2*_b[l2.GREgRpot0]*_b[l3.GREgRpot0])*_b[l.Y]) ///
	(r7: _b[l7.Y] ///
	+_b[l.GREgRpot0]*_b[l6.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l5.Y] ///
	+(_b[l.GREgRpot0]^3+2*_b[l.GREgRpot0]*_b[l2.GREgRpot0]+_b[l3.GREgRpot0])*_b[l4.Y] ///
	+(_b[l.GREgRpot0]^4+3*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]+2*_b[l.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^2+_b[l4.GREgRpot0])*_b[l3.Y] ///
	+(_b[l.GREgRpot0]^5+4*_b[l.GREgRpot0]^3*_b[l2.GREgRpot0]+3*_b[l.GREgRpot0]^2*_b[l3.GREgRpot0]+3*_b[l.GREgRpot0]*_b[l2.GREgRpot0]^2+2*_b[l.GREgRpot0]*_b[l4.GREgRpot0]+2*_b[l2.GREgRpot0]*_b[l3.GREgRpot0])*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^6+5*_b[l.GREgRpot0]^4*_b[l2.GREgRpot0]+4*_b[l.GREgRpot0]^3*_b[l3.GREgRpot0]+6*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]^2+3*_b[l.GREgRpot0]^2*_b[l4.GREgRpot0]+6*_b[l.GREgRpot0]*_b[l2.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^3+2*_b[l2.GREgRpot0]*_b[l4.GREgRpot0]+_b[l3.GREgRpot0]^2)*_b[l.Y]) ///
	(r8: _b[l8.Y] ///
	+_b[l.GREgRpot0]*_b[l7.Y] ///
	+(_b[l.GREgRpot0]^2+_b[l2.GREgRpot0])*_b[l6.Y] ///
	+(_b[l.GREgRpot0]^3+2*_b[l.GREgRpot0]*_b[l2.GREgRpot0]+_b[l3.GREgRpot0])*_b[l5.Y] ///
	+(_b[l.GREgRpot0]^4+3*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]+2*_b[l.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^2+_b[l4.GREgRpot0])*_b[l4.Y] ///
	+(_b[l.GREgRpot0]^5+4*_b[l.GREgRpot0]^3*_b[l2.GREgRpot0]+3*_b[l.GREgRpot0]^2*_b[l3.GREgRpot0]+3*_b[l.GREgRpot0]*_b[l2.GREgRpot0]^2+2*_b[l.GREgRpot0]*_b[l4.GREgRpot0]+2*_b[l2.GREgRpot0]*_b[l3.GREgRpot0])*_b[l3.Y] ///
	+(_b[l.GREgRpot0]^6+5*_b[l.GREgRpot0]^4*_b[l2.GREgRpot0]+4*_b[l.GREgRpot0]^3*_b[l3.GREgRpot0]+6*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]^2+3*_b[l.GREgRpot0]^2*_b[l4.GREgRpot0]+6*_b[l.GREgRpot0]*_b[l2.GREgRpot0]*_b[l3.GREgRpot0]+_b[l2.GREgRpot0]^3+2*_b[l2.GREgRpot0]*_b[l4.GREgRpot0]+_b[l3.GREgRpot0]^2)*_b[l2.Y] ///
	+(_b[l.GREgRpot0]^7+6*_b[l.GREgRpot0]^5*_b[l2.GREgRpot0]+5*_b[l.GREgRpot0]^4*_b[l3.GREgRpot0]+10*_b[l.GREgRpot0]^3*_b[l2.GREgRpot0]^2+4*_b[l.GREgRpot0]^3*_b[l4.GREgRpot0]+12*_b[l.GREgRpot0]^2*_b[l2.GREgRpot0]*_b[l3.GREgRpot0]+4*_b[l.GREgRpot0]*_b[l2.GREgRpot0]^3+6*_b[l.GREgRpot0]*_b[l2.GREgRpot0]*_b[l4.GREgRpot0]+3*_b[l.GREgRpot0]*_b[l3.GREgRpot0]^2+3*_b[l2.GREgRpot0]^2*_b[l3.GREgRpot0]+2*_b[l3.GREgRpot0]*_b[l4.GREgRpot0])*_b[l.Y]) ///
	, post

	test (r1=0) (r1+r2=0) (r1+r2+r3=0) (r1+r2+r3+r4=0) (r1+r2+r3+r4+r5=0) (r1+r2+r3+r4+r5+r6=0) (r1+r2+r3+r4+r5+r6+r7=0) (r1+r2+r3+r4+r5+r6+r7+r8=0)
	local pval_pot_irf_point=strofreal(r(p),"%4.3f")
	
	test (r1+r2+r3+r4+r5+r6+r7+r8=0)
	local pval_pot_irf2=strofreal(r(p),"%4.3f") 
	
	var dlogY if smpl0==1, lags(1/4) exog(l(0/8).Y D911 DGR)
	irf create irf1, step(8)
	
	preserve
	use myirf1.irf, clear
	keep if impulse=="Y" & response=="dlogY" & irfname=="irf1" & step==8
	local pointestadl=cdm      
	local standerradl=stdcdm
	restore
	local pval_act_irf=strofreal((1-normal(abs(`pointestadl'/`standerradl')))*2,"%4.3f")
	
	reg dlogY l(1/4).dlogY l(0/8).Y D911 DGR if smpl0==1, robust

	nlcom ///
	(p1: _b[l.Y]) ///
	(p2: _b[l2.Y] ///
	+_b[l.dlogY]*_b[l.Y]) ///
	(p3: _b[l3.Y] ///
	+_b[l.dlogY]*_b[l2.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l1.Y]) ///
	(p4: _b[l4.Y] ///
	+_b[l.dlogY]*_b[l3.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l2.Y] ///
	+(_b[l.dlogY]^3+2*_b[l.dlogY]*_b[l2.dlogY]+_b[l3.dlogY])*_b[l.Y]) ///
	(p5: _b[l5.Y] ///
	+_b[l.dlogY]*_b[l4.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l3.Y] ///
	+(_b[l.dlogY]^3+2*_b[l.dlogY]*_b[l2.dlogY]+_b[l3.dlogY])*_b[l2.Y] ///
	+(_b[l.dlogY]^4+3*_b[l.dlogY]^2*_b[l2.dlogY]+2*_b[l.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^2+_b[l4.dlogY])*_b[l.Y]) ///
	(p6: _b[l6.Y] ///
	+_b[l.dlogY]*_b[l5.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l4.Y] ///
	+(_b[l.dlogY]^3+2*_b[l.dlogY]*_b[l2.dlogY]+_b[l3.dlogY])*_b[l3.Y] ///
	+(_b[l.dlogY]^4+3*_b[l.dlogY]^2*_b[l2.dlogY]+2*_b[l.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^2+_b[l4.dlogY])*_b[l2.Y] ///
	+(_b[l.dlogY]^5+4*_b[l.dlogY]^3*_b[l2.dlogY]+3*_b[l.dlogY]^2*_b[l3.dlogY]+3*_b[l.dlogY]*_b[l2.dlogY]^2+2*_b[l.dlogY]*_b[l4.dlogY]+2*_b[l2.dlogY]*_b[l3.dlogY])*_b[l.Y]) ///
	(p7: _b[l7.Y] ///
	+_b[l.dlogY]*_b[l6.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l5.Y] ///
	+(_b[l.dlogY]^3+2*_b[l.dlogY]*_b[l2.dlogY]+_b[l3.dlogY])*_b[l4.Y] ///
	+(_b[l.dlogY]^4+3*_b[l.dlogY]^2*_b[l2.dlogY]+2*_b[l.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^2+_b[l4.dlogY])*_b[l3.Y] ///
	+(_b[l.dlogY]^5+4*_b[l.dlogY]^3*_b[l2.dlogY]+3*_b[l.dlogY]^2*_b[l3.dlogY]+3*_b[l.dlogY]*_b[l2.dlogY]^2+2*_b[l.dlogY]*_b[l4.dlogY]+2*_b[l2.dlogY]*_b[l3.dlogY])*_b[l2.Y] ///
	+(_b[l.dlogY]^6+5*_b[l.dlogY]^4*_b[l2.dlogY]+4*_b[l.dlogY]^3*_b[l3.dlogY]+6*_b[l.dlogY]^2*_b[l2.dlogY]^2+3*_b[l.dlogY]^2*_b[l4.dlogY]+6*_b[l.dlogY]*_b[l2.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^3+2*_b[l2.dlogY]*_b[l4.dlogY]+_b[l3.dlogY]^2)*_b[l.Y]) ///
	(p8: _b[l8.Y] ///
	+_b[l.dlogY]*_b[l7.Y] ///
	+(_b[l.dlogY]^2+_b[l2.dlogY])*_b[l6.Y] ///
	+(_b[l.dlogY]^3+2*_b[l.dlogY]*_b[l2.dlogY]+_b[l3.dlogY])*_b[l5.Y] ///
	+(_b[l.dlogY]^4+3*_b[l.dlogY]^2*_b[l2.dlogY]+2*_b[l.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^2+_b[l4.dlogY])*_b[l4.Y] ///
	+(_b[l.dlogY]^5+4*_b[l.dlogY]^3*_b[l2.dlogY]+3*_b[l.dlogY]^2*_b[l3.dlogY]+3*_b[l.dlogY]*_b[l2.dlogY]^2+2*_b[l.dlogY]*_b[l4.dlogY]+2*_b[l2.dlogY]*_b[l3.dlogY])*_b[l3.Y] ///
	+(_b[l.dlogY]^6+5*_b[l.dlogY]^4*_b[l2.dlogY]+4*_b[l.dlogY]^3*_b[l3.dlogY]+6*_b[l.dlogY]^2*_b[l2.dlogY]^2+3*_b[l.dlogY]^2*_b[l4.dlogY]+6*_b[l.dlogY]*_b[l2.dlogY]*_b[l3.dlogY]+_b[l2.dlogY]^3+2*_b[l2.dlogY]*_b[l4.dlogY]+_b[l3.dlogY]^2)*_b[l2.Y] ///
	+(_b[l.dlogY]^7+6*_b[l.dlogY]^5*_b[l2.dlogY]+5*_b[l.dlogY]^4*_b[l3.dlogY]+10*_b[l.dlogY]^3*_b[l2.dlogY]^2+4*_b[l.dlogY]^3*_b[l4.dlogY]+12*_b[l.dlogY]^2*_b[l2.dlogY]*_b[l3.dlogY]+4*_b[l.dlogY]*_b[l2.dlogY]^3+6*_b[l.dlogY]*_b[l2.dlogY]*_b[l4.dlogY]+3*_b[l.dlogY]*_b[l3.dlogY]^2+3*_b[l2.dlogY]^2*_b[l3.dlogY]+2*_b[l3.dlogY]*_b[l4.dlogY])*_b[l.Y]) ///
	, post
	
	test (p1=0) (p1+p2=0) (p1+p2+p3=0) (p1+p2+p3+p4=0) (p1+p2+p3+p4+p5=0) (p1+p2+p3+p4+p5+p6=0) (p1+p2+p3+p4+p5+p6+p7=0) (p1+p2+p3+p4+p5+p6+p7+p8=0)
	local pval_act_irf_point=strofreal(r(p),"%4.3f")
	
	test (p1+p2+p3+p4+p5+p6+p7+p8=0)
	local pval_act_irf2=strofreal(r(p),"%4.3f")
	
	sureg (E1: GREgRpot0 l(1/4).GREgRpot0 l(0/8).Y D911 DGR if smpl0==1) (E2: dlogY l(1/4).dlogY l(0/8).Y D911 DGR if smpl0==1), small dfk

	nlcom ///
	(r1: _b[E1:l.Y]) ///
	(r2: _b[E1:l2.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l.Y]) ///
	(r3: _b[E1:l3.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l1.Y]) ///
	(r4: _b[E1:l4.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l3.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^3+2*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]+_b[E1:l3.GREgRpot0])*_b[E1:l.Y]) ///
	(r5: _b[E1:l5.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l4.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l3.Y] ///
	+(_b[E1:l.GREgRpot0]^3+2*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]+_b[E1:l3.GREgRpot0])*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^4+3*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]+2*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^2+_b[E1:l4.GREgRpot0])*_b[E1:l.Y]) ///
	(r6: _b[E1:l6.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l5.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l4.Y] ///
	+(_b[E1:l.GREgRpot0]^3+2*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]+_b[E1:l3.GREgRpot0])*_b[E1:l3.Y] ///
	+(_b[E1:l.GREgRpot0]^4+3*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]+2*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^2+_b[E1:l4.GREgRpot0])*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^5+4*_b[E1:l.GREgRpot0]^3*_b[E1:l2.GREgRpot0]+3*_b[E1:l.GREgRpot0]^2*_b[E1:l3.GREgRpot0]+3*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]^2+2*_b[E1:l.GREgRpot0]*_b[E1:l4.GREgRpot0]+2*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0])*_b[E1:l.Y]) ///
	(r7: _b[E1:l7.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l6.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l5.Y] ///
	+(_b[E1:l.GREgRpot0]^3+2*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]+_b[E1:l3.GREgRpot0])*_b[E1:l4.Y] ///
	+(_b[E1:l.GREgRpot0]^4+3*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]+2*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^2+_b[E1:l4.GREgRpot0])*_b[E1:l3.Y] ///
	+(_b[E1:l.GREgRpot0]^5+4*_b[E1:l.GREgRpot0]^3*_b[E1:l2.GREgRpot0]+3*_b[E1:l.GREgRpot0]^2*_b[E1:l3.GREgRpot0]+3*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]^2+2*_b[E1:l.GREgRpot0]*_b[E1:l4.GREgRpot0]+2*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0])*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^6+5*_b[E1:l.GREgRpot0]^4*_b[E1:l2.GREgRpot0]+4*_b[E1:l.GREgRpot0]^3*_b[E1:l3.GREgRpot0]+6*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]^2+3*_b[E1:l.GREgRpot0]^2*_b[E1:l4.GREgRpot0]+6*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^3+2*_b[E1:l2.GREgRpot0]*_b[E1:l4.GREgRpot0]+_b[E1:l3.GREgRpot0]^2)*_b[E1:l.Y]) ///
	(r8: _b[E1:l8.Y] ///
	+_b[E1:l.GREgRpot0]*_b[E1:l7.Y] ///
	+(_b[E1:l.GREgRpot0]^2+_b[E1:l2.GREgRpot0])*_b[E1:l6.Y] ///
	+(_b[E1:l.GREgRpot0]^3+2*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]+_b[E1:l3.GREgRpot0])*_b[E1:l5.Y] ///
	+(_b[E1:l.GREgRpot0]^4+3*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]+2*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^2+_b[E1:l4.GREgRpot0])*_b[E1:l4.Y] ///
	+(_b[E1:l.GREgRpot0]^5+4*_b[E1:l.GREgRpot0]^3*_b[E1:l2.GREgRpot0]+3*_b[E1:l.GREgRpot0]^2*_b[E1:l3.GREgRpot0]+3*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]^2+2*_b[E1:l.GREgRpot0]*_b[E1:l4.GREgRpot0]+2*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0])*_b[E1:l3.Y] ///
	+(_b[E1:l.GREgRpot0]^6+5*_b[E1:l.GREgRpot0]^4*_b[E1:l2.GREgRpot0]+4*_b[E1:l.GREgRpot0]^3*_b[E1:l3.GREgRpot0]+6*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]^2+3*_b[E1:l.GREgRpot0]^2*_b[E1:l4.GREgRpot0]+6*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0]+_b[E1:l2.GREgRpot0]^3+2*_b[E1:l2.GREgRpot0]*_b[E1:l4.GREgRpot0]+_b[E1:l3.GREgRpot0]^2)*_b[E1:l2.Y] ///
	+(_b[E1:l.GREgRpot0]^7+6*_b[E1:l.GREgRpot0]^5*_b[E1:l2.GREgRpot0]+5*_b[E1:l.GREgRpot0]^4*_b[E1:l3.GREgRpot0]+10*_b[E1:l.GREgRpot0]^3*_b[E1:l2.GREgRpot0]^2+4*_b[E1:l.GREgRpot0]^3*_b[E1:l4.GREgRpot0]+12*_b[E1:l.GREgRpot0]^2*_b[E1:l2.GREgRpot0]*_b[E1:l3.GREgRpot0]+4*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]^3+6*_b[E1:l.GREgRpot0]*_b[E1:l2.GREgRpot0]*_b[E1:l4.GREgRpot0]+3*_b[E1:l.GREgRpot0]*_b[E1:l3.GREgRpot0]^2+3*_b[E1:l2.GREgRpot0]^2*_b[E1:l3.GREgRpot0]+2*_b[E1:l3.GREgRpot0]*_b[E1:l4.GREgRpot0])*_b[E1:l.Y]) ///
	(p1: _b[E2:l.Y]) ///
	(p2: _b[E2:l2.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l.Y]) ///
	(p3: _b[E2:l3.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l1.Y]) ///
	(p4: _b[E2:l4.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l3.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^3+2*_b[E2:l.dlogY]*_b[E2:l2.dlogY]+_b[E2:l3.dlogY])*_b[E2:l.Y]) ///
	(p5: _b[E2:l5.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l4.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l3.Y] ///
	+(_b[E2:l.dlogY]^3+2*_b[E2:l.dlogY]*_b[E2:l2.dlogY]+_b[E2:l3.dlogY])*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^4+3*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]+2*_b[E2:l.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^2+_b[E2:l4.dlogY])*_b[E2:l.Y]) ///
	(p6: _b[E2:l6.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l5.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l4.Y] ///
	+(_b[E2:l.dlogY]^3+2*_b[E2:l.dlogY]*_b[E2:l2.dlogY]+_b[E2:l3.dlogY])*_b[E2:l3.Y] ///
	+(_b[E2:l.dlogY]^4+3*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]+2*_b[E2:l.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^2+_b[E2:l4.dlogY])*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^5+4*_b[E2:l.dlogY]^3*_b[E2:l2.dlogY]+3*_b[E2:l.dlogY]^2*_b[E2:l3.dlogY]+3*_b[E2:l.dlogY]*_b[E2:l2.dlogY]^2+2*_b[E2:l.dlogY]*_b[E2:l4.dlogY]+2*_b[E2:l2.dlogY]*_b[E2:l3.dlogY])*_b[E2:l.Y]) ///
	(p7: _b[E2:l7.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l6.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l5.Y] ///
	+(_b[E2:l.dlogY]^3+2*_b[E2:l.dlogY]*_b[E2:l2.dlogY]+_b[E2:l3.dlogY])*_b[E2:l4.Y] ///
	+(_b[E2:l.dlogY]^4+3*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]+2*_b[E2:l.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^2+_b[E2:l4.dlogY])*_b[E2:l3.Y] ///
	+(_b[E2:l.dlogY]^5+4*_b[E2:l.dlogY]^3*_b[E2:l2.dlogY]+3*_b[E2:l.dlogY]^2*_b[E2:l3.dlogY]+3*_b[E2:l.dlogY]*_b[E2:l2.dlogY]^2+2*_b[E2:l.dlogY]*_b[E2:l4.dlogY]+2*_b[E2:l2.dlogY]*_b[E2:l3.dlogY])*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^6+5*_b[E2:l.dlogY]^4*_b[E2:l2.dlogY]+4*_b[E2:l.dlogY]^3*_b[E2:l3.dlogY]+6*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]^2+3*_b[E2:l.dlogY]^2*_b[E2:l4.dlogY]+6*_b[E2:l.dlogY]*_b[E2:l2.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^3+2*_b[E2:l2.dlogY]*_b[E2:l4.dlogY]+_b[E2:l3.dlogY]^2)*_b[E2:l.Y]) ///
	(p8: _b[E2:l8.Y] ///
	+_b[E2:l.dlogY]*_b[E2:l7.Y] ///
	+(_b[E2:l.dlogY]^2+_b[E2:l2.dlogY])*_b[E2:l6.Y] ///
	+(_b[E2:l.dlogY]^3+2*_b[E2:l.dlogY]*_b[E2:l2.dlogY]+_b[E2:l3.dlogY])*_b[E2:l5.Y] ///
	+(_b[E2:l.dlogY]^4+3*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]+2*_b[E2:l.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^2+_b[E2:l4.dlogY])*_b[E2:l4.Y] ///
	+(_b[E2:l.dlogY]^5+4*_b[E2:l.dlogY]^3*_b[E2:l2.dlogY]+3*_b[E2:l.dlogY]^2*_b[E2:l3.dlogY]+3*_b[E2:l.dlogY]*_b[E2:l2.dlogY]^2+2*_b[E2:l.dlogY]*_b[E2:l4.dlogY]+2*_b[E2:l2.dlogY]*_b[E2:l3.dlogY])*_b[E2:l3.Y] ///
	+(_b[E2:l.dlogY]^6+5*_b[E2:l.dlogY]^4*_b[E2:l2.dlogY]+4*_b[E2:l.dlogY]^3*_b[E2:l3.dlogY]+6*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]^2+3*_b[E2:l.dlogY]^2*_b[E2:l4.dlogY]+6*_b[E2:l.dlogY]*_b[E2:l2.dlogY]*_b[E2:l3.dlogY]+_b[E2:l2.dlogY]^3+2*_b[E2:l2.dlogY]*_b[E2:l4.dlogY]+_b[E2:l3.dlogY]^2)*_b[E2:l2.Y] ///
	+(_b[E2:l.dlogY]^7+6*_b[E2:l.dlogY]^5*_b[E2:l2.dlogY]+5*_b[E2:l.dlogY]^4*_b[E2:l3.dlogY]+10*_b[E2:l.dlogY]^3*_b[E2:l2.dlogY]^2+4*_b[E2:l.dlogY]^3*_b[E2:l4.dlogY]+12*_b[E2:l.dlogY]^2*_b[E2:l2.dlogY]*_b[E2:l3.dlogY]+4*_b[E2:l.dlogY]*_b[E2:l2.dlogY]^3+6*_b[E2:l.dlogY]*_b[E2:l2.dlogY]*_b[E2:l4.dlogY]+3*_b[E2:l.dlogY]*_b[E2:l3.dlogY]^2+3*_b[E2:l2.dlogY]^2*_b[E2:l3.dlogY]+2*_b[E2:l3.dlogY]*_b[E2:l4.dlogY])*_b[E2:l.Y]) ///
	, post
	
	test (r1=0) (r1+r2=0) (r1+r2+r3=0) (r1+r2+r3+r4=0) (r1+r2+r3+r4+r5=0) (r1+r2+r3+r4+r5+r6=0) (r1+r2+r3+r4+r5+r6+r7=0) (r1+r2+r3+r4+r5+r6+r7+r8=0)
	local pval_pot_irf_point2=strofreal(r(p),"%4.3f")
	test (r1+r2+r3+r4+r5+r6+r7+r8=0)
	local pval_pot_irf3=strofreal(r(p),"%4.3f")
	test (p1=0) (p1+p2=0) (p1+p2+p3=0) (p1+p2+p3+p4=0) (p1+p2+p3+p4+p5=0) (p1+p2+p3+p4+p5+p6=0) (p1+p2+p3+p4+p5+p6+p7=0) (p1+p2+p3+p4+p5+p6+p7+p8=0)
	local pval_act_irf_point2=strofreal(r(p),"%4.3f")
	test (p1+p2+p3+p4+p5+p6+p7+p8=0)
	local pval_act_irf3=strofreal(r(p),"%4.3f")
	test (r1=p1) (r1+r2=p1+p2) (r1+r2+r3=p1+p2+p3) (r1+r2+r3+r4=p1+p2+p3+p4) (r1+r2+r3+r4+r5=p1+p2+p3+p4+p5) (r1+r2+r3+r4+r5+r6=p1+p2+p3+p4+p5+p6) (r1+r2+r3+r4+r5+r6+r7=p1+p2+p3+p4+p5+p6+p7) (r1+r2+r3+r4+r5+r6+r7+r8=p1+p2+p3+p4+p5+p6+p7+p8)
	local pval_dif_irf_point=strofreal(r(p),"%4.3f")
	test (r1+r2+r3+r4+r5+r6+r7+r8=p1+p2+p3+p4+p5+p6+p7+p8)
	local pval_dif_irf=strofreal(r(p),"%4.3f")
	
	n disp "Potential"
	
	n display `pval_pot_irf_point'
	n display `pval_pot_irf_point2'
	n display `pval_pot_irf'
	n display `pval_pot_irf2'
	n display `pval_pot_irf3'
	
	n disp "Actual"
	
	n display `pval_act_irf_point'
	n display `pval_act_irf_point2'
	n display `pval_act_irf'
	n display `pval_act_irf2'
	n display `pval_act_irf3'
	
	n disp "Difference"
	
	n display `pval_dif_irf_point'
	n display `pval_dif_irf'

	irf ograph ///
	(irf1 Y dlogY cdm, ci level(`confidence') lcolor(black) ciopts(lcolor(gs14) fcolor(gs14)) lwidth(thick)) ///
	(irf0 Y GREgRpot0 cdm, ci level(`confidence') lcolor(blue) ciopts(lcolor(blue) lpattern(dash) fcolor(none))) ///
	, legend(order(3 1 4 2 6) ///
	label(3 "Actual Output, (`pval_act_irf2') [`pval_act_irf_point']") ///
	label(1 "`confidencestr' CI") ///
	label(2 "`confidencestr' CI") ///
	label(4 "Poten. Output, (`pval_pot_irf2') [`pval_pot_irf_point']") ///
	label(6 "Actual=Poten., (`pval_dif_irf') [`pval_dif_irf_point']") ///
	rows(3) ring(3) position(7)) ///
	xlabel(0(1)8) xtitle("") ///
	ytitle("output growth rate, percent, annualized") ///
	title("`var_str'") ///
	graphregion(color(white)) bgcolor(white) ///
	name(`var', replace)
		
	capture drop Y		
		
}

window manage close graph _all
graph combine TFP FP2 OILK, rows(1) ysize(2) graphregion(color(white)) plotregion(color(white)) t1title(Panel A: Supply Shocks) name(panela, replace)
graph combine MPOa DE1 sFP1SPF1, rows(1) ysize(2) graphregion(color(white)) plotregion(color(white)) t1title(Panel B: Demand Shocks) name(panelb, replace)

window manage close graph _all
graph combine panela panelb, rows(2) altshrink graphregion(color(white)) plotregion(color(white))
